#include <bits/stdc++.h>

#define int long long

using namespace std;

struct Vector {
    int x, y;

    int operator*(const Vector &b) const {
        return x * b.x + y * b.y;
    }

    int operator%(const Vector &b) const {
        return x * b.y - y * b.x;
    }

    Vector operator-(const Vector &b) const {
        return {x - b.x, y - b.y};
    }

    bool operator==(const Vector &b) const {
        return x == b.x && y == b.y;
    }
};

using Point = Vector;

struct Segment {
    Point a, b;

    bool contains(const Point &c) const {
        if (a == c || b == c)
            return true;
        int prod1 = (b - a) * (c - a);
        int prod2 = (a - b) * (c - b);
        int prod3 = (b - a) % (c - a);
        if (prod1 >= 0 && prod2 >= 0 && prod3 == 0)
            return true;
        return false;
    }

    bool is_intersec(const Segment &other) const {
        int prod1 = (b - a) % (other.b - a);
        int prod2 = (b - a) % (other.a - a);
        int prod3 = (other.b - other.a) % (b - other.a);
        int prod4 = (other.b - other.a) % (a - other.a);
        if (prod1 * prod2 <= 0 && prod3 * prod4 <= 0)
            return true;
        return false;
    }
};

vector<int> par, sz;

int get(int v) {
    if (v == par[v])
        return v;
    return par[v] = get(par[v]);
}

void merge(int a, int b) {
    a = get(a), b = get(b);
    if (a == b)
        return;
    if (sz[a] < sz[b])
        swap(a, b);
    sz[a] += sz[b];
    par[b] = a;
}

void solve() {
    par.clear(), sz.clear();
    int n;
    cin >> n;
    int ans = 1;
    vector<Segment> segs;
    for (int segid = 0; segid < n; ++segid) {
        Segment cur;
        cin >> cur.a.x >> cur.a.y >> cur.b.x >> cur.b.y;
        sz.push_back(1);
        par.push_back(par.size());
        vector<int> to_merge;
        for (int i = 0; i < segs.size(); ++i) {
            if (!cur.is_intersec(segs[i]))
                continue;
            ans += 1;
            to_merge.push_back(get(i));
        }
        sort(to_merge.begin(), to_merge.end());
        to_merge.resize(unique(to_merge.begin(), to_merge.end()) - to_merge.begin());
        ans -= to_merge.size();
        for (auto el: to_merge)
            merge(segid, el);
        segs.push_back(cur);
    }
    cout << ans << '\n';
}

signed main() {
    ios_base::sync_with_stdio(0), cin.tie(0);
    int tc;
    cin >> tc;
    while (tc--)
        solve();
}
